<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../classi/GeneratoreUrl.php";

    $geecomDb = new DbManager($costantiDatabase);	

    //dati admin
    $email    = filter_input(INPUT_POST,"email",FILTER_SANITIZE_ADD_SLASHES);
    $password = hash("sha512",$_POST['password']);

    $queryLogin = "SELECT * FROM geec_utenti WHERE email='$email' AND password='$password'";

    $result = $geecomDb->eseguiQueryLettura($queryLogin);
    if($result->num_rows>0) {
        $utente = $result->fetch_array(MYSQLI_ASSOC);
        if($utente["stato"]!="attivato") {
            header("Location: ../index.php?status=410");        
        }
        else {
            session_start();
            $_SESSION["geecomUser_id"] = $utente["id"];
            $_SESSION["geecomUser_email"] = $utente["email"];
            $_SESSION["geecomUser_nomeCognome"] = $utente["nome"]." ".$utente["cognome"];
            $_SESSION["geecomUser_nome"] = $utente["nome"];
            $_SESSION["geecomUser_tipoLogin"] = "email";
            $_SESSION["geecomUser_foto"] = ($utente["foto"]!="") ? $utente["foto"] : "immagini/altro/segnaPostoUtente.png";

            $gruppiUtente = array();
            $queryGruppo  = "SELECT idGruppo FROM geec_gruppiUtenti WHERE idUtente={$_SESSION["geecomUser_id"]}";
            $risnumMessaggi = $geecomDb->eseguiQueryLettura($queryGruppo);
            while($gruppo = $risnumMessaggi->fetch_assoc()) {
                $gruppiUtente[count($gruppiUtente)] = $gruppo["idGruppo"];
            }
            
            $_SESSION["geecomUser_gruppiUtente"] = $gruppiUtente;

            $data = date("Y-m-d");

            $datiLogin = $geecomDb->leggiSingolaRiga("geecAd_statistiche", 1);
            if($datiLogin==$data) { // ci sono già stati login oggi
                $queryLogin = "UPDATE geecAd_statistiche SET numeroLogin=numeroLogin+1, loginOggi=loginOggi+1 WHERE id=1";	
            }
            else { // è il primo login di oggi
                $queryLogin = "UPDATE geecAd_statistiche SET numeroLogin=numeroLogin+1, loginOggi=1, dataUltimoLogin='$data' WHERE id=1";	
            }
            $geecomDb->eseguiQueryScrittura($queryLogin);

            $impostazioni = recuperaImpostazioni($geecomDb);
            
            if($impostazioni["tipoRedirectLogin"]=="Home page di Geecom Admin") {
                $pagina       = $geecomDb->leggiSingolaRiga("geecAd_contenuti", $impostazioni["homePage"]);
                $linkPagina   = GeneratoreUrl::creaUrlContenuto($pagina, $impostazioni["ottimizzazioneUrl"], $impostazioni["urlPiattaforma"]);
                header("Location: $linkPagina");
            }
            else if($impostazioni["tipoRedirectLogin"]=="Home page di Geecom CMS") {
                $impostazioniGeecomCMS = $geecomDb->leggiSingolaRiga("geecB_impostazioni", 1);
                header("Location: {$impostazioniGeecomCMS["urlSito"]}");
            }
            else if($impostazioni["tipoRedirectLogin"]=="Link esterno") {
                header("Location: {$impostazioni["linkPersonalizzatoLogin"]}");
            }
        }
    }
    else {
        header("Location: ../index.php?status=400");
    }
